/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.saveAndContinue;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.google.gson.Gson;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.BottledTornado;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFileObfuscator;
import java.io.File;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveAndContinue {
    private static final Logger logger = LogManager.getLogger(SaveAndContinue.class.getName());
    public static final String save_path = "saves" + File.separator;
    public static final String IRONCLAD_FILE = save_path + AbstractPlayer.PlayerClass.IRONCLAD.name() + ".autosave";
    public static final String THE_SILENT_FILE = save_path + AbstractPlayer.PlayerClass.THE_SILENT.name() + ".autosave";
    public static final String CROWBOT_FILE = save_path + AbstractPlayer.PlayerClass.CROWBOT.name() + ".autosave";
    public static boolean ironcladSaveExists;
    public static boolean silentSaveExists;
    public static boolean crowbotSaveExists;

    private static boolean saveExists(AbstractPlayer.PlayerClass c) {
        String filepath = save_path + c.name() + ".autosave";
        boolean fileExists = Gdx.files.local(filepath).exists();
        if (fileExists && SaveAndContinue.loadSaveFile(c) == null) {
            SaveAndContinue.deleteSave(c);
            return false;
        }
        return fileExists;
    }

    public static void checkForSaves() {
        ironcladSaveExists = SaveAndContinue.saveExists(AbstractPlayer.PlayerClass.IRONCLAD);
        silentSaveExists = SaveAndContinue.saveExists(AbstractPlayer.PlayerClass.THE_SILENT);
        crowbotSaveExists = SaveAndContinue.saveExists(AbstractPlayer.PlayerClass.CROWBOT);
        logger.info("IRONCLAD SAVE EXISTS: " + ironcladSaveExists);
        logger.info("SILENT SAVE EXISTS: " + silentSaveExists);
        logger.info("ROBOT SAVE EXISTS: " + crowbotSaveExists);
    }

    public static String loadSaveString(AbstractPlayer.PlayerClass c) {
        String fileName = c.name() + ".autosave";
        FileHandle file = Gdx.files.local(save_path + fileName);
        String data = file.readString();
        if (data.contains("{")) {
            return data;
        }
        return SaveFileObfuscator.decode(data, "key");
    }

    public static SaveFile loadSaveFile(AbstractPlayer.PlayerClass c) {
        SaveFile retVal = null;
        try {
            Gson gson = new Gson();
            String savestr = SaveAndContinue.loadSaveString(c);
            retVal = gson.fromJson(savestr, SaveFile.class);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return retVal;
    }

    public static void save(SaveFile save) {
        CardCrawlGame.loadingSave = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", save.name);
        params.put("loadout", save.loadout);
        params.put("current_health", save.current_health);
        params.put("max_health", save.max_health);
        params.put("gold", save.gold);
        params.put("hand_size", save.hand_size);
        params.put("red", save.red);
        params.put("green", save.green);
        params.put("blue", save.blue);
        params.put("monsters_killed", save.monsters_killed);
        params.put("elites_killed", save.elites_killed);
        params.put("cards", save.cards);
        params.put("obtained_cards", save.obtained_cards);
        params.put("relics", save.relics);
        params.put("relic_counters", save.relic_counters);
        params.put("potions", save.potions);
        params.put("chose_neow_reward", save.chose_neow_reward);
        params.put("is_hardmode", save.is_hardmode);
        params.put("level_name", save.level_name);
        params.put("floor_num", save.floor_num);
        params.put("event_list", save.event_list);
        params.put("one_time_event_list", save.one_time_event_list);
        params.put("potion_chance", save.potion_chance);
        params.put("event_chances", save.event_chances);
        params.put("monster_list", save.monster_list);
        params.put("elite_monster_list", save.elite_monster_list);
        params.put("boss_list", save.boss_list);
        params.put("play_time", save.play_time);
        params.put("save_date", save.save_date);
        params.put("seed", save.seed);
        params.put("boss", save.boss);
        params.put("purgeCost", save.purgeCost);
        params.put("monster_seed_count", save.monster_seed_count);
        params.put("event_seed_count", save.event_seed_count);
        params.put("merchant_seed_count", save.merchant_seed_count);
        params.put("card_seed_count", save.card_seed_count);
        params.put("treasure_seed_count", save.treasure_seed_count);
        params.put("relic_seed_count", save.relic_seed_count);
        params.put("potion_seed_count", save.potion_seed_count);
        params.put("ai_seed_count", save.ai_seed_count);
        params.put("shuffle_seed_count", save.shuffle_seed_count);
        params.put("card_random_seed_count", save.card_random_seed_count);
        params.put("path_x", save.path_x);
        params.put("path_y", save.path_y);
        params.put("room_x", save.room_x);
        params.put("room_y", save.room_y);
        params.put("spirit_count", save.spirit_count);
        params.put("current_room", save.current_room);
        params.put("common_relics", save.common_relics);
        params.put("uncommon_relics", save.uncommon_relics);
        params.put("rare_relics", save.rare_relics);
        params.put("shop_relics", save.shop_relics);
        params.put("boss_relics", save.boss_relics);
        params.put("post_combat", save.post_combat);
        params.put("combat_rewards", save.combat_rewards);
        if (AbstractDungeon.player.hasRelic("Bottled Flame")) {
            params.put("bottled_flame", ((BottledFlame)AbstractDungeon.player.getRelic((String)"Bottled Flame")).card.cardID);
        } else {
            params.put("bottled_flame", null);
        }
        if (AbstractDungeon.player.hasRelic("Bottled Lightning")) {
            params.put("bottled_lightning", ((BottledLightning)AbstractDungeon.player.getRelic((String)"Bottled Lightning")).card.cardID);
        } else {
            params.put("bottled_lightning", null);
        }
        if (AbstractDungeon.player.hasRelic("Bottled Tornado")) {
            params.put("bottled_tornado", ((BottledTornado)AbstractDungeon.player.getRelic((String)"Bottled Tornado")).card.cardID);
        } else {
            params.put("bottled_tornado", null);
        }
        params.put("metric_campfire_rested", save.metric_campfire_rested);
        params.put("metric_campfire_upgraded", save.metric_campfire_upgraded);
        params.put("metric_campfire_rituals", save.metric_campfire_rituals);
        params.put("metric_campfire_meditates", save.metric_campfire_meditates);
        params.put("metric_purchased_purges", save.metric_purchased_purges);
        params.put("metric_potions_floor_spawned", save.metric_potions_floor_spawned);
        params.put("metric_potions_floor_usage", save.metric_potions_floor_usage);
        params.put("metric_current_hp_per_floor", save.metric_current_hp_per_floor);
        params.put("metric_max_hp_per_floor", save.metric_max_hp_per_floor);
        params.put("metric_gold_per_floor", save.metric_gold_per_floor);
        params.put("metric_path_per_floor", save.metric_path_per_floor);
        params.put("metric_path_taken", save.metric_path_taken);
        params.put("metric_items_purchased", save.metric_items_purchased);
        params.put("metric_items_purged", save.metric_items_purged);
        params.put("metric_card_choices", save.metric_card_choices);
        params.put("metric_event_choices", save.metric_event_choices);
        params.put("metric_boss_relics", save.metric_boss_relics);
        params.put("metric_damage_taken", save.metric_damage_taken);
        params.put("metric_build_version", save.metric_build_version);
        params.put("metric_seed_played", save.metric_seed_played);
        params.put("metric_floor_reached", save.metric_floor_reached);
        params.put("metric_playtime", save.metric_playtime);
        Gson gson = new Gson();
        String data = gson.toJson(params);
        String fileName = AbstractDungeon.player.chosenClass.name() + ".autosave";
        String path = save_path + fileName;
        FileHandle file = Gdx.files.local(path);
        long startTime = System.currentTimeMillis();
        if (Settings.isBeta) {
            FileHandle fileCopy = Gdx.files.local(path + "copy");
            fileCopy.writeString(data, false);
        }
        String saveData = SaveFileObfuscator.encode(data, "key");
        file.writeString(saveData, false);
        logger.info("File save time: " + (System.currentTimeMillis() - startTime) + "ms");
        logger.info("Auto-save complete");
    }

    public static void deleteSave(AbstractPlayer.PlayerClass c) {
        logger.info("DELETING " + c.name() + " SAVE");
        String fileName = c.name() + ".autosave";
        String path = save_path + fileName;
        Gdx.files.local(path).delete();
    }

    public static boolean isLoadingAutoSave(AbstractPlayer.PlayerClass selection) {
        switch (selection) {
            case IRONCLAD: {
                return ironcladSaveExists;
            }
            case THE_SILENT: {
                return silentSaveExists;
            }
            case CROWBOT: {
                return crowbotSaveExists;
            }
        }
        return false;
    }
}

